<?

/* Konstrukcje jezykowe zabronione przy uzyciu obfuscatora:
   - $$
   - dostp do prywatnych pol klasy gdzie indziej niz wewnatrz klasy i poprzez $this->, np. $zmienna->moje_pole
	Zamiast tego nalezy uzyc funkcji dostepowej, np. $zmienna->GetMojePole()
*/

   $VARS_COUNT = 0;
   $VARS = "";

   // Te identyfikatory nie beda modyfikowane
   $DONT_TOUCH =  array ( 'HTTP', 'db', 'smarty', 'mysqlhost', 'mysqluser', 'mysqlpass', 'mysqldb');

   // Te identyfikatory otrzymaja stae tokeny - bez czsci losowej
   $CONST_TOKEN =  array ( 'ftphost', 'ftpuser', 'ftppass', 'ftpdir', 'prefix');

   // Przetwarza cay katalog
   // $license_number - tajna informacja wkodowana do nowej nazwy identyfikatora
   // $dir - katalog
   // $tryb: get_vars - zmiana identyfikatorw, remove_BR - usunicie enterw, remove_comm - usunicie komentarzy
   // $verbose - cichy tryb pracy
   function ProcessDirectory($license_number, $dir, $tryb, $verbose)
   {
      srand(time());
      $dh=@opendir($dir);
      while ($file=@readdir($dh)) 
      {
         if($file!="." && $file!=".." ) 
         {
            $fullpath=$dir."/".$file;
            if(!is_dir($fullpath)) 
            {
         	if(strpos($file, '.php') !== false)
                {
                    if($tryb=='get_vars') GetVarsFromFile($license_number, $fullpath, $verbose);
                    if($tryb=='remove_BR') RemoveBR($fullpath, $verbose);
                    if($tryb=='remove_comm') RemoveComments($fullpath, $verbose);
                }
            } else
               ProcessDirectory($license_number, $fullpath, $tryb, $verbose);
         }
      }
      @closedir($dh);
   }

   if (!function_exists('ctype_alnum'))
   {
     function ctype_alnum($text)
     {
        return preg_match('/^[a-z0-9]*$/i', $text);
     }
   }

   // Wycignicie identyfikatora z kodu $text poczwszy od indeksu $start_len
   function GetStartingIdentifier($text, $start_len)
   {
      $len = $start_len;
      $OK = true;
      while($OK == true && $len < strlen($text))
      {

         if(!ctype_alnum($text[$len]) && $text[$len] != '_')
            $OK = false;
         else
            $len++;
      }
      return substr($text, $start_len, $len - $start_len);
   }

   // Funkcja zwraca zakodowan nazw identyfikatora $identifier
   // $license_number - tajna informacja wkodowana do nowej nazwy identyfikatora
   function GetIdentifierToken($license_number, $identifier)
   {
      global $CONST_TOKEN;
      $const_token = false;
      for($i=0; $i<count($CONST_TOKEN); $i++)
        if(strpos($identifier, $CONST_TOKEN[$i]) !== false)
          $const_token = true;
      do
      {
         $OK = true;
         $los = rand(0, 10000);
         if($const_token == true)
           $token = '_' . md5($identifier . $license_number) ;
         else
           $token = '_' . $los . md5($identifier . $license_number) ;

         for($i=0; $i<$VARS_COUNT; $i++)
         {
            if(	$VARS['token'][$i] == $token)
               $OK = false;
       		}
     }while(!$OK);
    	return $token;
   }

   // Przetworzenie identyfikatorw w pojedynczym pliku ($fullpath)
   // $license_number - tajna informacja wkodowana do nowej nazwy identyfikatora
   // $verbose - cichy tryb pracy
   function GetVarsFromFile($license_number, $fullpath, $verbose)
   {
      global $VARS, $VARS_COUNT, $DONT_TOUCH;
      $this_str = '$this->';
      if($verbose)
         echo "<HR>Analiza pliku $fullpath - zmiana nazw identyfikatorow<BR><BR>";
      if( file_exists($fullpath) )
      {
         $file = fopen($fullpath,'r');
         while( !feof($file)) $fcnt .= fgets($file,1000);
         fclose($file);
         $fcnt_org = '';
         // pierwszy przebieg - tworzymy tokeny dla zmiennych $ZMIENNA i pdomieniamy je
         $dollar_val = strpos($fcnt, '$');
         if($dollar_val === false) $fcnt_org = $fcnt;
         while($dollar_val !== false)
         {
            if($dollar_val !== false)
            {
               $identifier =  GetStartingIdentifier(substr($fcnt, $dollar_val), 1);
               $token = identifier;
               $touch = true;
               for($i=0; $i<count($DONT_TOUCH); $i++)
                  if(strpos($identifier, $DONT_TOUCH[$i]) !== false)
                     $touch = false;
               if(strpos($identifier, 'this') === false && $touch == true && (strpos($identifier, '_') === false || strpos($identifier, '_') > 0))
               {
                  $jest = false;
                  for($i=0; $i<$VARS_COUNT; $i++)
                     if($VARS['ident'][$i] == $identifier)
                     {
                        $jest = true;
                        $token = $VARS['token'][$i];
                     }
                  if(!$jest)
                  {
                     $VARS['ident'][$VARS_COUNT] = $identifier;
                     $token = GetIdentifierToken($license_number, $identifier);
                     $VARS['token'][$VARS_COUNT] = $token;
                     if($verbose)
                        echo "Identyfikator $identifier zmieniony na token: $token <BR>";
                     $VARS_COUNT++;
                  }
                  $fcnt = substr($fcnt, 0, $dollar_val + 1) . $token .substr($fcnt, $dollar_val + strlen($identifier) + 1);
                  $fcnt_org = $fcnt_org . substr($fcnt, 0, $dollar_val + strlen($token) + 1);
                  $fcnt = substr($fcnt, $dollar_val + strlen($token) + 1);
               }
               else
               {
                  $fcnt_org = $fcnt_org . substr($fcnt, 0, $dollar_val +  1);
                  $fcnt = substr($fcnt, $dollar_val +  1);
               }
            }
            $dollar_val = strpos($fcnt, '$');
         }
         $fcnt_org .= $fcnt;

         // drugi przebieg - szukamy zmiennych $this->identifier i podmieniamy jesli istnieje token
         $fcnt = $fcnt_org;
         $fcnt_org = '';
         $dollar_val = strpos($fcnt, $this_str);
         if($dollar_val !== false) $fcnt_org = '';
         while($dollar_val !== false)
         {
            if($dollar_val !== false)
            {
               $identifier =  GetStartingIdentifier(substr($fcnt, $dollar_val), strlen($this_str));
               $token = $identifier;
               $touch = true;
               for($i=0; $i<count($DONT_TOUCH); $i++)	

                  if(strpos($identifier, $DONT_TOUCH[$i]) !== false)
                     $touch = false;
               if(strpos($identifier, 'this') === false && $touch == true && (strpos($identifier, '_') === false || strpos($identifier, '_') > 0))
               {
                  for($i=0; $i<$VARS_COUNT; $i++)
                     if($VARS['ident'][$i] == $identifier)
                        $token = $VARS['token'][$i];
               }
               $fcnt = substr($fcnt, 0, $dollar_val + strlen($this_str)) . $token .
                  substr($fcnt, $dollar_val + strlen($identifier) + strlen($this_str));
               $fcnt_org = $fcnt_org . substr($fcnt, 0, $dollar_val + strlen($token) +strlen($this_str));
               $fcnt = substr($fcnt, $dollar_val + strlen($token) + strlen($this_str));
            }
            $dollar_val = strpos($fcnt, $this_str);

         }
         $fcnt_org .= $fcnt;
         $file = fopen($fullpath,'w');
         fputs($file, $fcnt_org);
         fclose($file);
      }      
   }

   // Usunicie przejcia do nowej linii w pliku $fullpath
   // $verbose - cichy tryb pracy
   function RemoveBR($fullpath, $verbose)
   {
      if($verbose)
         echo "<HR>Analiza pliku $fullpath - usuniecie zamania linii<BR><BR>";
      if( file_exists($fullpath) )
      {
         $file = fopen($fullpath,'r');
         while( !feof($file)) $fcnt .= fgets($file,1000);
         fclose($file);
         $fcnt = str_replace("\n", '', $fcnt);
         $fcnt = str_replace("\r", '', $fcnt);
        $file = fopen($fullpath,'w');
        fputs($file, $fcnt);
        fclose($file);
      }      
   }

   // Usunicie komentarzy w pliku $fullpath
   // $verbose - cichy tryb pracy
   function RemoveComments($fullpath, $verbose)
   {
      // dwa przebiegi, pierwszy usuwa od znakw // do koncow linii, drugi usuwa ca zawarto pliku pomiedzy /* a */
      if($verbose)
        echo "<HR>Analiza pliku $fullpath - usuniecie komentarzy<BR><BR>";
      if( file_exists($fullpath) )
      {
         // pierwszy przebieg
         $file = fopen($fullpath,'r');
         while( !feof($file)) $fcnt .= fgets($file);
         $lines = explode( "\n", $fcnt);
         for($i=0; $i<count($lines); $i++)
         {
            $comm_start = strpos($lines[$i], "//");
            $http_exist = strpos($lines[$i], "http://");
            $https_exist = strpos($lines[$i], "https://");
            $ftp_exist = strpos($lines[$i], "ftp://");
            if($comm_start !== false && $http_exist === false && $https_exist === false && $ftp_exist === false)
               $lines[$i] = substr($lines[$i], 0, $comm_start) ;
         }
         $fcnt = implode("\n", $lines);

         fclose($file);
         $file = fopen($fullpath,'w');
         fputs($file, $fcnt);
         fclose($file);

         // drugi przebieg
         $fcnt = "";
         $file = fopen($fullpath,'r');
         while( !feof($file)) $fcnt .= fgets($file,1000);
         fclose($file);
         $comm_start_pos = strpos($fcnt, "/*");

         while($comm_start_pos !== false)
         {
            $comm_end_pos = strpos($fcnt, "*/", $comm_start_pos);
            if($comm_end_pos !== false)
            {
               $fcnt = substr($fcnt, 0, $comm_start_pos) . substr($fcnt, $comm_end_pos + 2 );
               $comm_start_pos = strpos($fcnt, "/*");
            }
            else $comm_start_pos = false;
         }
         $file = fopen($fullpath,'w');
         fputs($file, $fcnt);
         fclose($file);
      }
   }

   // Wykonanie zaciemnienia wszystkich plikw w katalogu
   // $license_number - tajna informacja wkodowana do nowej nazwy identyfikatora
   // $dir - cieka do katalogu
   // $verbose - cichy tryb pracy
   function ExecuteAllDirectory($license_number, $dir, $verbose)
   {
      ProcessDirectory($license_number, $dir, 'get_vars', $verbose);
      ProcessDirectory($license_number, $dir, 'remove_comm', $verbose);
      ProcessDirectory($license_number, $dir, 'remove_BR', $verbose);
   }

   // Wykonanie zaciemnienia pojedynczego pliku
   // $license_number - tajna informacja wkodowana do nowej nazwy identyfikatora
   // $file - cieka do pliku
   // $verbose - cichy tryb pracy
   function ExecuteAllFile($license_number, $file, $verbose)
   {
      GetVarsFromFile($license_number, $file, $verbose);
      RemoveComments($file, $verbose);
      RemoveBR($file, $verbose);
   }
?>
